﻿namespace Hims.Api.Utilities
{
    using System;
    using Microsoft.AspNetCore.Mvc;

    /// <inheritdoc />
    /// <summary>
    /// The base controller.
    /// </summary>
    public class BaseController : Controller
    {
        /// <summary>
        /// The mail server error.
        /// </summary>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
        protected string MailServerError() => "Due to mail server issue we are unable to send mails at this moment. Please contact an administrator for further details.";

        /// <summary>
        /// The SMS server error.
        /// </summary>
        /// <returns>
        /// The <see cref="string"/>.
        /// </returns>
       // protected string SMSServerError() => "Due to SMS server issue we are unable to send messages at this moment. Please contact an administrator for further details.";
        protected string SMSServerError() => "SUCCESSS";

        /// <summary>
        /// The success.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="ObjectResult"/>.
        /// </returns>
        protected ObjectResult Success(object model = null) => this.StatusCode(200, model);

        /// <summary>
        /// The bad request.
        /// </summary>
        /// <returns>
        /// The <see cref="ObjectResult"/>.
        /// </returns>
        protected new ObjectResult BadRequest() => this.StatusCode(400, string.Empty);

        /// <summary>
        /// The bad request.
        /// </summary>
        /// <param name="message">
        /// The message.
        /// </param>
        /// <returns>
        /// The <see cref="ObjectResult"/>.
        /// </returns>
        protected ObjectResult BadRequest(string message) => this.StatusCode(400, message ?? string.Empty);

        /// <summary>
        /// The failed request.
        /// </summary>
        /// <returns>
        /// The <see cref="StatusCodeResult"/>.
        /// </returns>
        protected ObjectResult Failed() => this.StatusCode(417, "Sorry error occurred, Please try again later.");

        /// <summary>
        /// The failed request.
        /// </summary>
        /// <param name="message">
        /// The message.
        /// </param>
        /// <returns>
        /// The <see cref="ObjectResult"/>.
        /// </returns>
        protected ObjectResult Failed(string message) => this.StatusCode(417, message ?? string.Empty);

        /// <summary>
        /// The forbidden request.
        /// </summary>
        /// <param name="message">
        /// The message.
        /// </param>
        /// <returns>
        /// The <see cref="ObjectResult"/>.
        /// </returns>
        protected ObjectResult Forbidden(string message) => this.StatusCode(403, message ?? string.Empty);

        /// <summary>
        /// The server error.
        /// </summary>
        /// <returns>
        /// The <see cref="StatusCodeResult"/>.
        /// </returns>
        protected ObjectResult ServerError() => this.StatusCode(500, "Sorry error occurred, Please try again later.");

        /// <summary>
        /// The server error.
        /// </summary>
        /// <param name="message">
        /// The message.
        /// </param>
        /// <returns>
        /// The <see cref="StatusCodeResult"/>.
        /// </returns>
        protected ObjectResult ServerError(string message) => this.StatusCode(500, message);

        /// <summary>
        /// The server error.
        /// </summary>
        /// <param name="exception">
        /// The exception.
        /// </param>
        /// <returns>
        /// The <see cref="StatusCodeResult"/>.
        /// </returns>
        protected ObjectResult ServerError(Exception exception) => this.StatusCode(500, exception.Message);
    }
}